﻿var workstations = {
    context: $(".v-workstations"),
    datatable: null,
    treeview: null,
    getSelectedFolderId: function () {
        var folder = workstations.treeview.a4listview("getHighlightedNode");
        return folder ? (folder.Id || 0) : 0;
    },
    initializeDataTable: function (folderId) {
        this.datatable = $(".h-workstationsTable", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getAction("GetWorkStations", "MultiMode", "Settings"),
            ajaxParams: { "folderId": folderId },
            columns: [
                { "Title": resources.Id, "Data": "Id" },
                { "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Title": resources.Status, "Data": "StatusEnum", "Name": "Status", "Type": "enum", "EnumType": "SurveyStatus" },
                { "Title": resources.ProntoServer, "Data": "ProntoName", "Type": "multiple", "EnumType": "TelephonyServerOptions" },
                { "Title": resources.ComputerName, "Data": "ComputerName" },
                { "Title": resources.MSILineNumber, "Data": "StationNo" },
                { "Title": resources.Folder, "Data": "FolderName" }
            ],
            stateKey: "WorkStations",
            advancedFilter: true,
            allowRowSelection: function (data) { return data.Status == 1; },
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE', data.Permissions); } }
            ],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('DELETE', data.Permissions); } },
                { "Action": "properties", "Label": resources.Properties, "DisplayCondition": function (data) { return voxco.security.has('READ', data.Permissions); } },
                { "Divider": true },
                { "Action": "activate", "Label": resources.Activate, "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('START_STOP', data.Permissions); } },
                { "Action": "stop", "Label": resources.Stop, "DisplayCondition": function (data) { return data.Status == 3 && voxco.security.has('START_STOP', data.Permissions); } }

            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "delete":
                        workstations.deleteWorkStations([row.Id]);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditWorkStation", "MultiMode", "Settings", { id: row.Id }), 550, 700, { afterClose: function () { workstations.refreshContent(); } });
                        break;
                    case "activate":
                        workstations.startWorkStation(row.Id);
                        break;
                    case "stop":
                        workstations.stopWorkStation(row.Id);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                if (action == "delete") {
                    workstations.deleteWorkStations(ids);
                }
            },
            localizableTexts: { "Search": resources.SearchWorkstations }
        });
    },
    initializeTreeView: function () {
        this.treeview = $(".h-workstationFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetWorkStationFolders", "MultiMode", "Settings"),
            icons: {
                Custom: [
                    { Condition: function (data) { return data.FolderType == 8; }, Icon: "workstation" }
                ]
            },
            stateKey: "WorkStations",
            draw: function (event, data) {
                var folder = data.selectedNode;
                var folderId = folder ? (folder.Id || 0) : 0;

                if (workstations.datatable) {
                    workstations.datatable.a4datatable("option", "ajaxParams", { "folderId": folderId });
                    workstations.datatable.a4datatable("refresh");
                }
                else {
                    workstations.initializeDataTable(folderId);
                }

                workstations.selectNodeCallback(folder);

                $(".v-tableContainer", workstations.context).toggleClass("right-panel", data.count > 1);
                $(this).toggle(data.count > 1);
            },
            selectNode: function (event, data) {
                workstations.datatable.a4datatable("option", "ajaxParams", { "folderId": data.node.Id });
                workstations.datatable.a4datatable("refresh", true);

                workstations.selectNodeCallback(data.node);
            },
            actionButtons: [
                {
                    Action: "start", Label: resources.Activate, Icon: "activate",
                    "DisplayCondition": function (data) { return data.Status == 1 && voxco.security.has('START_STOP_GROUP', data.Permissions); }
                },
                {
                    Action: "stop", Label: resources.Stop, Icon: "deactivate",
                    "DisplayCondition": function (data) { return data.Status == 3 && voxco.security.has('START_STOP_GROUP', data.Permissions); }
                },
                {
                    Action: "properties", Label: resources.Properties, Icon: "edit",
                    DisplayCondition: function (data) { return data.ParentId > 0 && voxco.security.has('READ_GROUP', data.Permissions); }
                },
                {
                    Action: "delete", Label: resources.Delete, Icon: "remove",
                    DisplayCondition: function (data) { return data.ParentId > 0 && data.Status == 1 && voxco.security.has('DELETE_GROUP', data.Permissions); }
                }
            ],
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "start":
                        workstations.startFolder(node.Id, node.Name, node.FolderType);
                        break;
                    case "stop":
                        workstations.stopFolder(node.Id, node.Name, node.FolderType);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("WorkStationFolderProperties", "MultiMode", "Settings", { id: node.Id, folderType: node.FolderType }), 250, 600, { afterClose: function () { workstations.refreshContent(); } });
                        break;
                    case "delete":
                        workstations.deleteFolder(node.Id, node.FolderType == 8);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchWorkstationFoldersAndLists },
            highlightFirstNode: true
        });
    },
    selectNodeCallback: function (folder) {
        if (folder) {
            var menu = $("#main-header .h-newWorkStationMenu", workstations.context);

            var canCreateChild = voxco.security.has('CREATE', folder.Permissions) && folder.FolderType == 8;
            $(".h-newWorkStation", menu).toggle(canCreateChild);

            var canCreateFolder = voxco.security.has('CREATE_GROUP', folder.Permissions) && folder.FolderType != 8;
            $(".h-newWorkStationFolder, .h-newWorkStationList", menu).toggle(canCreateFolder);

            menu.toggle(canCreateChild || canCreateFolder);
        }
    },
    bindEvents: function () {
        $(".h-newWorkStationMenu").on("click", "li.h-newWorkStation", function () {
            modalDialog.showWindow(a4.getAction("EditWorkStation", "MultiMode", "Settings", { folderId: workstations.getSelectedFolderId() }), 550, 700, {
                afterClose: function () {
                    workstations.refreshContent();
                }
            });
        });

        $(".h-newWorkStationMenu").on("click", "li.h-newWorkStationFolder", function () {
            modalDialog.showWindow(a4.getAction("WorkStationFolderProperties", "MultiMode", "Settings", { parentId: workstations.getSelectedFolderId() }), 250, 600, {
                afterClose: function () {
                    workstations.refreshContent();
                }
            });
        });

        $(".h-newWorkStationMenu").on("click", "li.h-newWorkStationList", function () {
            modalDialog.showWindow(a4.getAction("WorkStationFolderProperties", "MultiMode", "Settings", { parentId: workstations.getSelectedFolderId(), folderType: 8 }), 250, 600, {
                afterClose: function () {
                    workstations.refreshContent();
                }
            });
        });

    },
    deleteFolder: function (id, isWorkStationList) {
        var message = isWorkStationList ? confirmDeleteWorkStationListResources : confirmDeleteWorkStationListFoldersResources;
        modalDialog.showConfirmDelete(message, function () {
            a4.callServerMethod(a4.getAction("DeleteWorkStationFolder", "MultiMode", "Settings"), { id: id },
                function (result) {
                    workstations.refreshContent();
                });
        }, 1);
    },
    deleteWorkStations: function (ids) {
        modalDialog.showConfirmDelete(confirmDeleteWorkStationsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteWorkStations", "MultiMode", "Settings"), { ids: ids },
                function (result) {
                    workstations.refreshContent();
                });
        }, ids.length);
    },
    refreshContent: function () {
        workstations.treeview.a4listview("refresh");
    },
    startFolder: function (folderId, folderName, folderType) {
        modalDialog.showConfirmDialog(folderType == 8 ? confirmActivateWorkStationListResources : confirmActivateFolderResources, function () {
            a4.callServerMethod(a4.getAction("StartWorkStationFolder", "MultiMode", "Settings"), { folderId: folderId }, function (result) {
                workstations.refreshContent();
            });
        }, null, null, false, { "folder": folderName });
    },
    stopFolder: function (folderId, folderName, folderType) {
        modalDialog.showConfirmDialog(folderType == 8 ? confirmStopWorkStationListResources : confirmStopFolderResources, function () {
            a4.callServerMethod(a4.getAction("StopWorkStationFolder", "MultiMode", "Settings"), { folderId: folderId }, function (result) {
                workstations.refreshContent();
            });
        }, null, null, false, { "folder": folderName });
    },
    startWorkStation: function (id) {
        a4.callServerMethod(a4.getAction("StartWorkStation", "MultiMode", "Settings"), { id: id }, function (result) {
            workstations.refreshContent();
        });
    },
    stopWorkStation: function (id) {
        a4.callServerMethod(a4.getAction("StopWorkStation", "MultiMode", "Settings"), { id: id }, function (result) {
            workstations.refreshContent();
        });
    }
}

$(document).ready(function () {
    if (workstations.context.length > 0) {
        workstations.initializeTreeView();
        workstations.bindEvents();
    }
});